<?php
namespace model;

class User extends BaseUser
{
	// Migration
	public static function migration($model_name)
	{
		return array_merge(parent::migration($model_name), array
		(
			array('ADD', array
			(
				'avatar'		=>	'VARCHAR(255)',
				'description'	=>	'TEXT',
				'points'		=>	'INT UNSIGNED DEFAULT 0',
				'views'			=>	'INT UNSIGNED DEFAULT 0',
				'rating'		=>	'FLOAT DEFAULT 0',
				'unread'		=>	'INT UNSIGNED DEFAULT 0'
			))
		));
	}
	
	// Administration
	public function listing()
	{
		return array_merge(parent::listing(), array
		(
			'points'	=>	$this->points
		));
	}
	
	// Validation
	public function columns($preset, $action, $form)
	{
		$columns = parent::columns($preset, $action, $form);
		
		if($action == 'edit' || $preset == 'administrate')
		{
			if($preset != 'administrate')
			{
				$columns['current_password'] = array('password', array('c_current_password'=>array($this, 'current_password')));
			}
			
			$columns['avatar'] = array('file', array('optional'=>true, 'file_type'=>'image', 'image_size'=>array(100, 100)));
			$columns['description'] = array('textarea', array());
		}
		
		if($preset == 'administrate')
		{
			$columns['points'] = array('text', array('non_negative_integer'=>true));
		}
		
		return $columns;
	}
	
	public function current_password($password)
	{
		return hash_hmac('md5', $password, SECRET) == $this->password;
	}
	
	public function fields($action, $fields, $preset)
	{
		$row = parent::fields($action, $fields, $preset);
		
		if($action == 'edit' || $preset == 'administrate')
		{
			$row['avatar'] = $fields['avatar'];
			$row['description'] = $fields['description'];
		} else
		{
			$row['avatar'] = '';
			$row['description'] = '';
		}
		
		if($preset == 'administrate')
		{
			$row['points'] = $fields['points'];
		}
		
		return $row;
	}
	
	// Avatar
	private function identicon()
	{
		$this->avatar = $this->id.'.png';
		
		$avatar = \lib\identicons\Identicon::create(md5($this->id), 100);
		
		imagepng($avatar, $this->filePath('avatar').$this->avatar);
	}
	
	// Create
	public function create($name='instance', $preset='default')
	{
		$form = parent::create($name, $preset);
		
		if($form->valid && !$this->avatar)
		{
			$this->identicon();
		}
		
		return $form;
	}
	
	// Edit
	public function edit($name='instance', $preset='default')
	{
		$form = parent::edit($name, $preset);
		
		if($form->valid && !$this->avatar)
		{
			$this->identicon();
		}
		
		return $form;
	}
	
	// Session
	public static function session()
	{
		if(isset($_GET['log_out']))
		{
			parent::unauthenticate();
		}
		
		$session = parent::session();
		
		if(!$session->authenticated())
		{
			$register = self::register_form();
			
			if($register->valid && isset($_COOKIE['r']))
			{
				if($referer = \model\User::get('WHERE id=?', $_COOKIE['r'])->fetch())
				{
					$referer->awardPoints(10);
				}
			}
			
			\lib\Template::vars(array
			(
				'log_in'			=>	self::log_in_form(),
				'register'			=>	$register,
				'forgot_password'	=>	self::forgot_password_form()
			));
			
			return parent::session();
		}
		
		return $session;
	}
	
	// Points
	public function awardPoints($points)
	{
		$this->points = $this->points + $points;
		
		$instance = new \model\Points(array
		(
			'user_id'	=>	$this->id,
			'points'	=>	$points
		), true);
		
		$instance->create();
	}
	
	// Experience level
	public function exp_level()
	{
		return floor(0.5 + sqrt(25+4*$this->points)/10);
	}
	
	public function experience()
	{
		$level = $this->exp_level();
		
		return $this->points - 25*$level*($level-1);
	}
	
	public function max_experience()
	{
		return $this->exp_level()*50;
	}
	
	public function points_progress()
	{
		return $this->experience()/$this->max_experience()*100;
	}
	
	// Rank
	public function rank($game_id=false)
	{
		return \model\User::num_rows('WHERE points>?', $this->points) + 1;
	}
	
	// Comments
	public function comments()
	{
		return \model\Comment::num_rows('WHERE user_id=?', $this->id);
	}
	
	// Ratings
	public function ratings()
	{
		return \model\Rating::num_rows('WHERE user_id=?', $this->id);
	}
	
	// Favourites
	public function favourites()
	{
		return \model\Favourite::num_rows('WHERE user_id=?', $this->id);
	}
}